<?php
function update_sample_state_for_reconfig_sb($argv) {
	/* check number of arguments */
	if(count($argv) != 4) {
		echo "Usage: update_sample_state_for_reconfig_sb DB_HOST DB_USERNAME DB_PASSWORD MODE\n";
		exit(1);
	}

	/* fetch arguments */
	$db_host = escapeshellarg($argv[0]);
	$db_username = escapeshellarg($argv[1]);
	$db_password = escapeshellarg($argv[2]);
	$before_or_after_reconfig_sb = $argv[3];
	
	/* execute main function */
	$connection = pg_connect("host=$db_host dbname=dtasdb user=$db_username password=$db_password");
	if($connection == false) {
		echo 'pg_connect: ' . pg_last_error();
		exit(1);
	}

	if ( $before_or_after_reconfig_sb == 0 ) { # before reconfig sb
		$queryResult = pg_query_params($connection, "UPDATE tb_file_queue SET state = 'S' WHERE fhid IN 
						( SELECT fhid from tb_file_history WHERE familyid IN 
						( SELECT familyid from tb_file_history as h, tb_file_queue as q WHERE h.fhid = q.fhid GROUP by familyid having min(q.state)='A' AND count(*) = 1 ))", array());
	}
	else if ( $before_or_after_reconfig_sb == 1 ) { # after reconfig sb
		$queryResult = pg_query_params($connection, "UPDATE tb_file_queue SET state = 'A' WHERE state = 'S'", array());
	}
    
	if($queryResult == false) {
		echo 'pg_query: ' . pg_last_error();
        pg_close($connection);
		exit(1);
	}

	pg_close($connection);
	exit(0);
}
